/** @file   simon.h
 * @brief   Declaration of Simon - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SIMON_H
#define H_WWW_SIMON_H

#include "npccharacter.h"

namespace WeWantWar {

/** @class  Simon
 * @brief   Simon is one of the characters that help us.
 * @author  Tomi Lamminsaari
 *
 */
class Simon : public NpcCharacter
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	Simon();


	/** Destructor
   */
	virtual ~Simon();

private:

	/** Copy constructor.
   * @param     rO                Reference to another Simon
   */
  Simon( const Simon& rO );

	/** Assignment operator
   * @param     rO                Reference to another Simon
   * @return    Reference to us.
   */
  Simon& operator = ( const Simon& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this object.
   */
  virtual void update();
  


  ///
  /// Getter methods
  /// ==============
  
  /** Returns the type of this object.
   * @return    ObjectID::TYPE_SIMON
   */
  virtual ObjectID::Type objectType() const;
  


protected:

  ///
  /// Members
  /// =======

  eng2d::Vec2D  m_movementVec;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: simon.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:15+02  lamminsa
 * Initial revision
 *
 */
 
